package gov.va.med.mhv.integration.phr.transfer;

import java.io.Serializable;
import java.util.Date;

/**
 * Parameter class for refreshData requests.
 *
 * The service expects an icn and non empty list of station numbers.
 * 
 * User: Rob Murtha
 */
public class RefreshDataParameters implements Serializable {
	
	private static final String DEFAULT_EXTRACT_TYPE = "ALL";
	
    private PatientIdentifier patient;
    private String extractType = DEFAULT_EXTRACT_TYPE;
    private Date rangeStart;
    private Date rangeEnd;
    
    private static final long serialVersionUID = 6737213961267125985L;

    public RefreshDataParameters(PatientIdentifier patient) {
        this.patient = patient;
    }

    public PatientIdentifier getPatient() {
        return this.patient;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof RefreshDataParameters)) return false;

        RefreshDataParameters that = (RefreshDataParameters) o;

        if (patient != null ? !patient.equals(that.patient) : that.patient != null) return false;
        if (extractType != null && !extractType.equals(that.extractType)) return false;
        
        long rangeStartThis = rangeStart != null ? rangeStart.getTime() : -1L;
        long rangeStartThat = that.rangeStart != null ? that.rangeStart.getTime() : -1L;
        if(rangeStartThis != rangeStartThat) return false;
        
        long rangeEndThis = rangeEnd != null ? rangeEnd.getTime() : -1L;
        long rangeEndThat = that.rangeEnd != null ? that.rangeEnd.getTime() : -1L;
        if(rangeEndThis != rangeEndThat) return false;
        
        if(!extractType.equals(that.extractType)) return false;
        
        return true;
    }

    public int hashCode() {
    	int hash = 1;
    	hash = hash * 17 + (patient != null ? patient.hashCode() : 0); 
    	hash = hash * 31 + (rangeStart != null ? rangeStart.hashCode() : 0);
    	hash = hash *  7 + (rangeEnd != null ? rangeEnd.hashCode() : 0);
    	hash = hash * 13 + (extractType.hashCode());
    	
    	return hash;
    }

    public String toString() {
        return "RefreshDataParameters{" +
                "patient=" + patient +
                '}';
    }
    
    /**
     * 
     * @return
     */
    public String getExtractType() {
		return extractType;
	}

    /**
     * Set the type of extract to perform.
     * @param extractType
     */
	public void setRefreshExtractType(String extractType) {
		this.extractType = extractType;
	}

	/**
	 * Set the range parameters for the request.
	 * @param start The beginning of the range.
	 * @param end The end of the range.
	 */
	public void setRefreshDateRange(Date start, Date end) {
		this.rangeStart = (start != null) ? start : this.rangeStart;
		this.rangeEnd = (end != null) ? end : this.rangeEnd;
	}
	
	public Date getRangeEnd() {
		return rangeEnd;
	}
	
	public Date getRangeStart() {
		return rangeStart;
	}
}


